//Total Outlay(Expenditure) Method
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Concept Information
//Total Outlay = Price per unit * Demand in units

price=[8,7,6,5,4]         //per Kg in rupees
total_expenditure=[0,7000,12000,15000,16000]        //in rupees

mprintf('   Price per kg     Total Expenditure')
mprintf('\n    (in rupees)\t      (in rupees)')
for i=1:5
    mprintf('\n       %d\t\t%d',price(i),total_expenditure(i))
end

//Case 1:Price falls from 7/kg to 5/kg
mprintf('\n\n    Price per kg     Total Expenditure')
mprintf('\n    (in rupees)\t      (in rupees)')
mprintf('\n\t%d        \t%d',price(2),total_expenditure(2))
mprintf('\n\t%d        \t%d',price(4),total_expenditure(4))
if total_expenditure(2) > total_expenditure(4) then
    mprintf("\nE > 1")
    mprintf("\nMore than Unity")
    mprintf("\nTotal expenditure increases as a result of decline in price")
else
    mprintf("\nE < 1")
    mprintf("\nLess than Unity")
    mprintf("\nTotal expenditure decreases as a result of increase in price")
end


//Case 2:Price rises from 5/kg to 7/kg 
mprintf('\n\n    Price per kg     Total Expenditure')
mprintf('\n    (in rupees)\t      (in rupees)')
mprintf('\n\t%d        \t%d',price(4),total_expenditure(4))
mprintf('\n\t%d        \t%d',price(2),total_expenditure(2))
if total_expenditure(2) > total_expenditure(4) then
    mprintf("\nE > 1")
    mprintf("\nMore than Unity")
    mprintf("\nTotal expenditure increases as a result of decline in price")
else
    mprintf("\nE < 1")
    mprintf("\nLess than Unity")
    mprintf("\nTotal expenditure decreases as a result of increase in price")
end

//Output
//    Price per kg     Total Expenditure
//    (in rupees)	      (in rupees)
//       8		0
//       7		7000
//       6		12000
//       5		15000
//       4		16000
//
//    Price per kg     Total Expenditure
//    (in rupees)	      (in rupees)
//	7        	7000
//	5        	15000
//E < 1
//Less than Unity
//Total expenditure decreases as a result of increase in price
//
//    Price per kg     Total Expenditure
//    (in rupees)	      (in rupees)
//	5        	15000
//	7        	7000
//E < 1
//Less than Unity
//Total expenditure decreases as a result of increase in price
